/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import slimeknights.tconstruct.library.modifiers.ModifierHook;

public class ModifierHooks {
    private static final Map<class_2960, ModifierHook<?>> HOOKS = new ConcurrentHashMap();

    private ModifierHooks() {
    }

    @Nullable
    public static ModifierHook<?> getHook(class_2960 name) {
        return HOOKS.get(name);
    }

    public static <T extends ModifierHook<?>> T register(T hook) {
        if (HOOKS.containsKey(hook.getName())) {
            throw new IllegalArgumentException("Attempt to register duplicate modifier hook " + String.valueOf(hook.getName()));
        }
        HOOKS.put(hook.getName(), hook);
        return hook;
    }

    public static <T> ModifierHook<T> register(class_2960 name, Class<T> filter, T defaultInstance, @Nullable Function<Collection<T>, T> merger) {
        return ModifierHooks.register(new ModifierHook<T>(name, filter, defaultInstance, merger));
    }

    public static <T> ModifierHook<T> register(class_2960 name, Class<T> filter, T defaultInstance) {
        return ModifierHooks.register(name, filter, defaultInstance, null);
    }
}

